// CrossMaker
// crossmaker.h

// plugin ID is for testing only
#ifndef ID_CROSSMAKER
#define ID_CROSSMAKER 1000005
#endif

// forward declarations
Bool RegisterCrossMaker(void);

// data structure for the cross
struct cCross
{
public:
	Float crossWidth;
	Float crossHeight;
};

// CrossMaker class
class CrossMaker : public ObjectData
{
	INSTANCEOF(CrossMaker, ObjectData)

public:
	virtual Bool Init(GeListNode *node);
	virtual Bool Message(GeListNode *node, Int32 type, void *data);
	virtual SplineObject* GetContour(BaseObject *op, BaseDocument *doc, Float lod, BaseThread *bt);
	static NodeData* Alloc(void) {return NewObjClear(CrossMaker); }

	SplineObject* GenerateCross(cCross ACross);
	static void OrientObject(SplineObject* op, Int32 plane, Bool reverse);
	void ResetValues(GeListNode *node);
};
