// DialogExample - main.cpp

#include "c4d.h"

// forward declarations
Bool RegisterDialogExample(void);

Bool PluginStart(void)
{
	Bool success;

	// attempt to register our plugin with C4D; display a message in the console depending on the result
	if(!RegisterDialogExample())
	{
		GePrint("Failed to register the Dialog Example");
		success = FALSE;
	} else {
		GePrint("Dialog Example successfully loaded.");
		success = TRUE;
	}
	GePrint(" ");
	return success;
}

void PluginEnd(void)
{
	// nothing to do here as we haven't allocated any resources which must be freed
	return;
}

Bool PluginMessage(Int32 id, void *data)
{
	// handle incoming messages
	switch (id)
	{
	case C4DPL_INIT_SYS:
		if(!resource.Init())
		{
			GePrint("Dialog Example: failed to load resource file.");
			return FALSE;					// don't start plugin without its resource
		}
		else
		{
			return TRUE;
		}
		break;

	case C4DMSG_PRIORITY:
		return TRUE;
		break;

	default:
		return FALSE;
	}

	return TRUE;
}
