//////////////////////////////////////////////////////////////////////////
// Diamond ObjectData plugin
// diamond.h
//////////////////////////////////////////////////////////////////////////

#include "c4d.h"

// plugin ID
#ifndef ID_DIAMOND
#define ID_DIAMOND 100008		// <----- be sure to get a unique plugin DI from Maxon if you intend to develop and use this plugin!!!
#endif

// constants
#define HANDLES 2
#define DEFAULT_DIAMOND_WIDTH 200
#define DEFAULT_DIAMOND_HEIGHT 400

// forward declarations
Bool RegisterDiamond(void);

// object generator class
class Diamond : public ObjectData
{
	INSTANCEOF(Diamond, ObjectData)

public:

	virtual void GetHandle(BaseObject *op, Int32 i, HandleInfo &info);
	virtual void SetHandle(BaseObject *op, Int32 i, Vector p, const HandleInfo &info);
	virtual DRAWRESULT Draw(BaseObject *op, DRAWPASS drawpass, BaseDraw *bd, BaseDrawHelp *bh);

	virtual BaseObject* GetVirtualObjects(BaseObject *op, HierarchyHelp *hh);
	virtual Bool Init(GeListNode *node);
	virtual void GetDimension(BaseObject *op, Vector *mp, Vector *rad);
	virtual Int32 GetHandleCount(BaseObject *op);

	BaseObject* Diamond::GenerateObject(Vector *padr, Int32 pcnt, Int32 vcnt, BaseThread *bt);

	static NodeData* Alloc(void) { return NewObjClear(Diamond); }
};

