#include "maxon/application.h"
#include "maxon/datadescriptiondefinitiondatabase.h"
#include "maxon/datadescriptiondatabase.h"
#include "maxon/datadescription_data.h"
#include "maxon/descriptionprocessor.h"
#include "maxon/micronodes.h"

#include "c4d.h"
#include "splitvel_descriptions.h"

namespace maxonsdk
{
static maxon::BaseArray<maxon::GenericData> g_coreNodeDescriptions;
static maxon::Id g_corenodesDatabaseId = maxon::Id("uk.co.microbion.splitveldb");

using namespace maxon::corenodes;

class SplitVel
{
public:
	MAXON_PORT_INPUT(maxon::Vector, velocity);
	MAXON_PORT_OUTPUT(maxon::Vector, direction);
	MAXON_PORT_OUTPUT(maxon::Float, speed);

	class Impl : public BasicMicroNode
	{
	public:
		MAXON_ATTRIBUTE_FORCE_INLINE maxon::Result<void> Process(const Ports<velocity, direction, speed>& ports) const
		{
			iferr_scope;

			const maxon::Vector vel = ports.velocity();
			const maxon::Float spd = vel.GetLength();
			maxon::Vector vel2 = vel.GetNormalized();

			ports.direction.Update(vel2);
			ports.speed.Update(spd);

			return maxon::OK;
		}
	};

	static maxon::Result<void> Init(const MicroNodeGroupRef& group)
	{
		return group.AddChild<Impl>();
	}
};

	// We choose pure registration, because the node has no lazy evaluation (and is evaluated from left to right).
	MAXON_CORENODE_REGISTER_PURE(SplitVel, microbion::SPLITVELOCITY::SPLITVELNODE::GetId());

	static maxon::Result<void> HandleInitializeModule()
	{
		iferr_scope_handler
		{
			err.CritStop();
			return err;
		};

		// get plugin location
		const maxon::Url& binaryUrl = maxon::g_maxon.GetUrl();
		// get plugin folder
		maxon::Url pluginDir = binaryUrl.GetDirectory();
		// get resource folder
		const maxon::Url coreNodesResourceUrl = pluginDir.Append("res"_s).Append("nodes"_s) iferr_return;

		// Load core node descriptions (they register automatically).
		maxon::DataDescriptionDefinitionDatabaseInterface::RegisterDatabaseWithUrl(g_corenodesDatabaseId, coreNodesResourceUrl) iferr_return;

		return maxon::OK;
	}

	static void HandleFreeModule()
	{
		iferr_scope_handler
		{
			err.CritStop();
			return;
		};

		g_coreNodeDescriptions.Reset();

	}

	MAXON_INITIALIZATION(HandleInitializeModule, HandleFreeModule);

} // namespace maxonsdk
