/************************************************************************/
/* ToggleGI - plugin to toggle global illumination on and off           */
/* This plugin is open source - feel free to modify, change, etc. as	*/
/* much as you like.													*/
/*																		*/
/* By Steve Pedler, February 16th 2011									*/
/************************************************************************/

// ToggleGI - main.cpp

#include "c4d.h"

// forward declarations
Bool RegisterToggleGI(void);

Bool PluginStart(void)
{
	Bool success;

	// attempt to register our plugin with C4D; display a message in the console depending on the result
	if(!RegisterToggleGI())
	{
		GePrint("Failed to register ToggleGI");
		success = FALSE;
	} else {
		GePrint("ToggleGI successfully loaded.");
		success = TRUE;
	}
	GePrint(" ");							// just prints a blank line
	return success;
}

void PluginEnd(void)
{
	// nothing to do here as we haven't allocated any resources which must be freed
	return;
}

Bool PluginMessage(Int32 id, void *data)
{
	// handle incoming messages
	switch (id)
	{
	case C4DPL_INIT_SYS:
		// normally we would load a resource file here, but this plugin doesn't have one
		return TRUE;
		break;

	case C4DMSG_PRIORITY:
		return TRUE;
		break;

	default:
		return FALSE;
	}

	return TRUE;
}
