// BMFlip
// bmflip.cpp

// includes
#include "c4d.h"
#include "bmflip.h"
#include "xbmflip.h"
#include "c4d_symbols.h"

SHADERINFO BitmapFlip::GetRenderInfo(BaseShader *sh)
{
	return SHADERINFO_BUMP_SUPPORT;
}

Bool BitmapFlip::Init(GeListNode *node)
{
	shader = NULL;
	flipX = FALSE;
	flipY = FALSE;
	return TRUE;
}

void BitmapFlip::FreeRender(BaseShader *chn)
{
	if(shader)
		shader->FreeRender();
	shader = NULL;
}

Bool BitmapFlip::Message(GeListNode *node, LONG type, void *msgdat)
{
	BaseContainer *data;

	data = ((BaseShader*)node)->GetDataInstance();
	HandleInitialChannel(node, BMFLIPSHADER_TEXTURE, type, msgdat);
	HandleShaderMessage(node, (BaseShader*)data->GetLink(BMFLIPSHADER_TEXTURE, node->GetDocument(), Xbase), type, msgdat);

	return TRUE;
}

INITRENDERRESULT BitmapFlip::InitRender(BaseShader *chn, const InitRenderStruct& irs)
{
	BaseContainer *data;
	INITRENDERRESULT result;

	data = chn->GetDataInstance();
	// get gadget values
	flipX = data->GetBool(BMFLIPSHADER_FLIPX);
	flipY = data->GetBool(BMFLIPSHADER_FLIPY);
	shader = (BaseShader*)data->GetLink(BMFLIPSHADER_TEXTURE, irs.doc, Xbase);
	if(shader)
	{
		result = shader->InitRender(irs);
		return result;
	}

	return INITRENDERRESULT_OK;
}

Vector BitmapFlip::Output(BaseShader *chn, ChannelData *cd)
{
	Vector res, uv;

	if(!shader) return Vector(0.0, 0.0, 0.0);		// return black if no bitmap present

	uv = cd->p;
	if(flipX)
		cd->p.x = 1.0 - cd->p.x;
	if(flipY)
		cd->p.y = 1.0 - cd->p.y;
	res = shader->Sample(cd);
	cd->p = uv;

	return res;										// otherwise return the bitmap
}

// register the plugin
Bool RegisterBMFlip(void)
{
	String name;
	name = "Bitmap Transform";
	if(RegisterShaderPlugin(ID_BMFLIP, GeGetDefaultFilename(DEFAULTFILENAME_SHADER_EFFECTS) + String("Bitmap Transform"), 0, BitmapFlip::Alloc,"Xbmflip", 0))
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}

}
