// iniread.cpp
// class to open and manipulate ini-format files

#include "c4d.h"
#include "iniread.h"

// IniRead implementation

IniRead::IniRead(void)
{
	// nothing to do
	;
}

IniRead::~IniRead(void)
{
	// nothing to do
	;
}

String IniRead::leftTrim(String str)
{
	// remove whitespace from left of string
	LONG i;

	for(i = 0; i< str.GetLength(); i++)
	{
		if(str[i] != ' ' && str[i] != '\n' && str[i] != '\t' && str[i] != '\r')
			break;
	}

	str.Delete(0, i);
	return str;
}

String IniRead::rightTrim(String str)
{
	// remove whitespace from right of string
	LONG i;

	for (i = str.GetLength()-1; i >= 0; i--)
	{
		if(str[i] != ' ' && str[i] != '\n' && str[i] != '\t' && str[i] != '\r')
			break;
	}

	str.Delete(i+1, str.GetLength()-i);
	return str;
}

String IniRead::allTrim(String str)
{
	str = leftTrim(str);
	str = rightTrim(str);
	
	return str;
}

String IniRead::getKey(String str)
{
	String key;
	LONG pos;

	// find the first '=' character
	if(str.FindFirst("=", &pos, 0L))		// is there an '='
	{
		key = str.SubStr(0, pos);
	}
	else
		key = "";

	return rightTrim(key);
}

String IniRead::getValue(String str)
{
	String value;
	LONG pos;

	if(str.FindFirst("=", &pos, 0L))
	{
		value = str.SubStr(pos+1, str.GetLength()-pos);
	}
	else
		value = "";

	value = allTrim(value);			// remove spaces
	value = removeQuotes(value);	// remove leading and trailing double quotes

	return value;
}

String IniRead::removeQuotes(String str)
{
	// remove double quotes from left of string
	LONG i;

	for(i = 0; i< str.GetLength(); i++)
	{
		if(str[i] != '"')
			break;
	}
	str.Delete(0, i);
	
	//now remove double quotes from right of string
	for (i = str.GetLength()-1; i >= 0; i--)
	{
		if(str[i] != '"')
			break;
	}

	str.Delete(i+1, str.GetLength()-i);
	
	return str;
}

LONG IniRead::compareNoCase(String str1, String str2)
{
	return str1.ToLower().Compare(str2.ToLower());
}
